﻿using System;

namespace Eliza
{
    /// <summary>
    /// The Eliza driver program.
    /// </summary>
    class Program
    {
        /// <summary>
        /// Defines the entry point of the application.
        /// </summary>
        /// <param name="args">The arguments.</param>
        static void Main(string[] args)
        {
            // Initialize Eliza and greet the user
            bool conversationOver = false;
            IEliza eliza = new Eliza();
            Console.WriteLine(eliza.WelcomeMessage);

            // Converse with the user until the conversation is over
            while (!conversationOver) {
                Console.Write("> ");
                string input = Console.ReadLine();
                Console.WriteLine(Environment.NewLine + eliza.GetResponse(input, out conversationOver));
            }

            // Close window
            Console.WriteLine("\nPress ENTER to close window...");
            Console.ReadLine();
        }
    }
}
